//
//  AppDelegate.h
//  Kyopon Schedule Sync
//
//  Created by FUJIDANA on 06/09/18.
//  Copyright FUJIDANA 2006. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class ISyncClient, ISyncSession;
@class WXKProgressWindowController;


@protocol WXKSyncing

- (ISyncClient *)syncClient;
- (NSArray *)syncFilters;

- (void)removeAllLocalRecordsOfEntityName:(NSString *)entityName;
- (void)acceptOrDenyChangesWithEntityNames:(NSArray *)entityNames session:(ISyncSession *)session;

@end


@interface AppDelegate : NSObject
{
	IBOutlet NSWindow            *window;
	// IBOutlet NSWindow *progressWindow;
//	IBOutlet NSTextField         *progressTextField;
//	IBOutlet NSProgressIndicator *progressIndicator;
	IBOutlet NSArrayController   *arrayController;
	
	WXKProgressWindowController  *_progressWindowController;
	
	NSPersistentStoreCoordinator *persistentStoreCoordinator;
	NSManagedObjectModel         *managedObjectModel;
	NSManagedObjectContext       *managedObjectContext;
	
	id <WXKSyncing>              _syncController;
}

- (NSPersistentStoreCoordinator *)persistentStoreCoordinator;
- (NSManagedObjectModel *)managedObjectModel;
- (NSManagedObjectContext *)managedObjectContext;

- (IBAction)saveAction:(id)sender;

@end

@interface AppDelegate (Sync)

- (id <WXKSyncing>)syncController;
- (void)setSyncController:(id <WXKSyncing>)value;

- (IBAction)sync:(id)sender;

@end

@interface AppDelegate (Communication)

- (IBAction)send:(id)sender;

@end
